﻿#region << Using Directives >>
using System;
#endregion

namespace Volpe.Cafe.Generic
{
    /// <summary>
    /// Represents an object that stores compliance modeling data for each safety class. This object supports deep member cloning by
    /// requiring that each variable of this generic class implement the <see cref="ICloneable"/> interface.
    /// </summary>
    [Serializable]
    public class SCObject<T> : SCValue<T>, ICloneable where T : ICloneable
    {

        #region /*** Ctors ***/

        /// <summary>
        /// Initializes a new instance of the <see cref="SCObject{T}"/> class.
        /// </summary>
        public SCObject() : base() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SCObject{T}"/> class using the specified values.
        /// </summary>
        public SCObject(T pc, T lt, T cm) : base(pc, lt, cm) { }

        #endregion

        #region /*** Methods ***/

        #region /* ICloneable Members */

        /// <summary>
        /// Creates a copy of the current <see cref="SCObject{T}"/> instance.
        /// </summary>
        /// <returns>A new object that is a copy of this <see cref="SCObject{T}"/>.</returns>
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        /// <summary>
        /// Creates a copy of the current <see cref="SCObject{T}"/> instance.
        /// </summary>
        /// <returns>A new object that is a copy of this <see cref="SCObject{T}"/>.</returns>
        public new SCObject<T> Clone()
        {
            SCObject<T> value = new SCObject<T>();
            this.CopyTo(value);
            return value;
        }
        /// <summary>
        /// Copies the members of the current <see cref="SCObject{T}"/> instance into the specified value.
        /// </summary>
        /// <param name="value">The value where to copy the members of the current instance.</param>
        protected void CopyTo(SCObject<T> value)
        {
            for (int i = 0; i < this.Items.Length; i++)
            {
                value.Items[i] = (T)this.Items[i].Clone();
            }
        }

        #endregion

        #endregion

    }
}
